public class Integration {
    public static double rect(MathFunction func, double a, double b, int n) {
        double h= (b-a)/n;
        double answer=0.0;
        for (int i=0; i < n; i++)
            answer += func.f(a+i*h);		// Left edge
        return h*answer;
    }
    
    public static double trap(MathFunction func, double a, double b, int n) {
        double h= (b-a)/n;
        double answer= func.f(a)/2.0;
        for (int i=1; i <= n; i++)
            answer += func.f(a+i*h);		// Common edge
        answer -= func.f(b)/2.0;
        return h*answer;
    }
    
    public static double simp(MathFunction func, double a, double b, int n) {
        // Each panel has area (h/6)*(f(x) + 4f(x+h/2) + f(x+h))
        double h= (b-a)/n;
        double answer= func.f(a);
        for (int i=1; i <= n; i++)
            answer += 4.0*func.f(a+i*h-h/2.0) + 2.0*func.f(a+i*h);
        answer -= func.f(b);
        return h*answer/6.0;
    }
        
   public static void main(String[] args) {
       double r= Integration.rect(new Quartic(), 0.0, 8.0, 200);
       System.out.println("Rectangle: " + r);
       double t= Integration.trap(new Quartic(), 0.0, 8.0, 200);
       System.out.println("Trapezoid: " + t);
       double s= Integration.simp(new Quartic(), 0.0, 8.0, 200);
       System.out.println("Simpson: " + s);
   }
}	// Problems: no accuracy estimate, inefficient, only closed intervals, etc.